/*************************************************************************/
/*                                                                       */
/*   SNU-RT Benchmark Suite for Worst Case Timing Analysis               */
/*   =====================================================               */
/*                              Collected and Modified by S.-S. Lim      */
/*                                           sslim@archi.snu.ac.kr       */
/*                                         Real-Time Research Group      */
/*                                        Seoul National University      */
/*                                                                       */
/*                                                                       */
/*        < Features > - restrictions for our experimental environment   */
/*                                                                       */
/*          1. Completely structured.                                    */
/*               - There are no unconditional jumps.                     */
/*               - There are no exit from loop bodies.                   */
/*                 (There are no 'break' or 'return' in loop bodies)     */
/*          2. No 'switch' statements.                                   */
/*          3. No 'do..while' statements.                                */
/*          4. Expressions are restricted.                               */
/*               - There are no multiple expressions joined by 'or',     */
/*                'and' operations.                                      */
/*          5. No library calls.                                         */
/*               - All the functions needed are implemented in the       */
/*                 source file.                                          */
/*                                                                       */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/*  FILE: bs.c                                                           */
/*  SOURCE : Public Domain Code                                          */
/*                                                                       */
/*  DESCRIPTION :                                                        */
/*                                                                       */
/*     Binary search for the array of 15 integer elements.               */
/*                                                                       */
/*  REMARK :                                                             */
/*                                                                       */
/*  EXECUTION TIME :                                                     */
/*                                                                       */
/*                                                                       */
/*************************************************************************/


struct DATA {
  int  key;
  int  value;
}  ;

#ifdef DEBUG
int cnt1;
#endif 

#define TABSIZE 800

struct DATA data[TABSIZE] = {
  {0,807},
  {2,1249},
  {4,73},
  {6,1658},
  {8,930},
  {10,1272},
  {12,1544},
  {14,878},
  {16,1923},
  {18,1709},
  {20,440},
  {22,165},
  {24,492},
  {26,1042},
  {28,1987},
  {30,503},
  {32,327},
  {34,1729},
  {36,840},
  {38,612},
  {40,303},
  {42,1169},
  {44,1709},
  {46,1157},
  {48,1560},
  {50,933},
  {52,1099},
  {54,278},
  {56,1816},
  {58,1335},
  {60,1097},
  {62,1826},
  {64,1512},
  {66,1267},
  {68,1810},
  {70,1633},
  {72,979},
  {74,1149},
  {76,579},
  {78,821},
  {80,1967},
  {82,672},
  {84,1393},
  {86,1336},
  {88,1485},
  {90,1745},
  {92,1228},
  {94,91},
  {96,194},
  {98,357},
  {100,1001},
  {102,1153},
  {104,708},
  {106,1944},
  {108,1668},
  {110,1490},
  {112,124},
  {114,196},
  {116,1530},
  {118,903},
  {120,1722},
  {122,666},
  {124,549},
  {126,24},
  {128,1801},
  {130,853},
  {132,977},
  {134,1408},
  {136,228},
  {138,933},
  {140,298},
  {142,981},
  {144,635},
  {146,13},
  {148,1865},
  {150,1814},
  {152,1063},
  {154,536},
  {156,1425},
  {158,1669},
  {160,115},
  {162,94},
  {164,1629},
  {166,501},
  {168,517},
  {170,195},
  {172,105},
  {174,404},
  {176,1451},
  {178,298},
  {180,188},
  {182,1123},
  {184,1505},
  {186,882},
  {188,752},
  {190,1566},
  {192,716},
  {194,337},
  {196,438},
  {198,1144},
  {200,1501},
  {202,897},
  {204,1871},
  {206,1828},
  {208,1137},
  {210,1358},
  {212,1177},
  {214,397},
  {216,294},
  {218,1904},
  {220,1609},
  {222,231},
  {224,1745},
  {226,175},
  {228,1635},
  {230,298},
  {232,142},
  {234,399},
  {236,1968},
  {238,412},
  {240,260},
  {242,1557},
  {244,1594},
  {246,8},
  {248,395},
  {250,1968},
  {252,1113},
  {254,530},
  {256,1006},
  {258,962},
  {260,1942},
  {262,1365},
  {264,82},
  {266,1852},
  {268,767},
  {270,1821},
  {272,1695},
  {274,712},
  {276,1671},
  {278,1901},
  {280,590},
  {282,831},
  {284,738},
  {286,1057},
  {288,1616},
  {290,1790},
  {292,1640},
  {294,679},
  {296,1335},
  {298,1006},
  {300,1972},
  {302,98},
  {304,1095},
  {306,1319},
  {308,1454},
  {310,1223},
  {312,289},
  {314,760},
  {316,905},
  {318,126},
  {320,123},
  {322,1506},
  {324,1813},
  {326,770},
  {328,1238},
  {330,1094},
  {332,220},
  {334,1844},
  {336,366},
  {338,534},
  {340,1226},
  {342,1394},
  {344,1363},
  {346,738},
  {348,1844},
  {350,1590},
  {352,550},
  {354,1159},
  {356,623},
  {358,947},
  {360,1385},
  {362,1217},
  {364,1272},
  {366,1539},
  {368,1247},
  {370,385},
  {372,1496},
  {374,885},
  {376,623},
  {378,420},
  {380,144},
  {382,1968},
  {384,1735},
  {386,1915},
  {388,1625},
  {390,1534},
  {392,42},
  {394,11},
  {396,679},
  {398,152},
  {400,1244},
  {402,1295},
  {404,818},
  {406,396},
  {408,1692},
  {410,1815},
  {412,991},
  {414,33},
  {416,669},
  {418,1397},
  {420,1553},
  {422,547},
  {424,1825},
  {426,1210},
  {428,1662},
  {430,211},
  {432,1808},
  {434,1377},
  {436,761},
  {438,625},
  {440,1335},
  {442,1868},
  {444,1995},
  {446,776},
  {448,767},
  {450,1439},
  {452,1874},
  {454,1331},
  {456,556},
  {458,301},
  {460,872},
  {462,560},
  {464,94},
  {466,984},
  {468,1755},
  {470,1789},
  {472,1407},
  {474,15},
  {476,193},
  {478,769},
  {480,1680},
  {482,1455},
  {484,855},
  {486,1506},
  {488,963},
  {490,1502},
  {492,676},
  {494,1108},
  {496,1249},
  {498,331},
  {500,1844},
  {502,1638},
  {504,808},
  {506,1997},
  {508,651},
  {510,849},
  {512,1203},
  {514,1731},
  {516,531},
  {518,14},
  {520,1419},
  {522,775},
  {524,9},
  {526,180},
  {528,1929},
  {530,1223},
  {532,54},
  {534,260},
  {536,737},
  {538,1545},
  {540,1317},
  {542,1525},
  {544,200},
  {546,256},
  {548,1564},
  {550,597},
  {552,648},
  {554,1704},
  {556,1550},
  {558,1150},
  {560,1976},
  {562,1412},
  {564,554},
  {566,797},
  {568,504},
  {570,381},
  {572,748},
  {574,1065},
  {576,1378},
  {578,1699},
  {580,209},
  {582,1129},
  {584,553},
  {586,1483},
  {588,447},
  {590,607},
  {592,773},
  {594,1322},
  {596,305},
  {598,1176},
  {600,53},
  {602,1224},
  {604,630},
  {606,366},
  {608,1400},
  {610,444},
  {612,1370},
  {614,285},
  {616,1016},
  {618,1898},
  {620,155},
  {622,1133},
  {624,1557},
  {626,576},
  {628,1178},
  {630,266},
  {632,1357},
  {634,1711},
  {636,1878},
  {638,614},
  {640,819},
  {642,1737},
  {644,1133},
  {646,591},
  {648,1720},
  {650,762},
  {652,633},
  {654,197},
  {656,31},
  {658,588},
  {660,589},
  {662,873},
  {664,877},
  {666,1304},
  {668,1358},
  {670,1200},
  {672,1254},
  {674,960},
  {676,915},
  {678,1947},
  {680,1480},
  {682,1730},
  {684,1955},
  {686,546},
  {688,1107},
  {690,1238},
  {692,0},
  {694,926},
  {696,1035},
  {698,857},
  {700,1113},
  {702,114},
  {704,1593},
  {706,1360},
  {708,354},
  {710,418},
  {712,1357},
  {714,585},
  {716,1729},
  {718,1015},
  {720,563},
  {722,102},
  {724,917},
  {726,643},
  {728,1419},
  {730,967},
  {732,1747},
  {734,1269},
  {736,1395},
  {738,1303},
  {740,473},
  {742,1103},
  {744,1748},
  {746,385},
  {748,1658},
  {750,1459},
  {752,1406},
  {754,1930},
  {756,1824},
  {758,1132},
  {760,973},
  {762,1603},
  {764,897},
  {766,1920},
  {768,1950},
  {770,1231},
  {772,480},
  {774,203},
  {776,1900},
  {778,520},
  {780,533},
  {782,1258},
  {784,1003},
  {786,676},
  {788,950},
  {790,1934},
  {792,780},
  {794,1879},
  {796,1832},
  {798,574},
  {800,1549},
  {802,542},
  {804,249},
  {806,771},
  {808,310},
  {810,1879},
  {812,983},
  {814,1970},
  {816,40},
  {818,723},
  {820,1650},
  {822,971},
  {824,1229},
  {826,318},
  {828,1746},
  {830,299},
  {832,1230},
  {834,1621},
  {836,776},
  {838,124},
  {840,244},
  {842,958},
  {844,1696},
  {846,771},
  {848,1064},
  {850,1560},
  {852,598},
  {854,751},
  {856,1940},
  {858,503},
  {860,1551},
  {862,801},
  {864,1205},
  {866,1080},
  {868,418},
  {870,1274},
  {872,1649},
  {874,413},
  {876,1320},
  {878,1025},
  {880,12},
  {882,1783},
  {884,788},
  {886,117},
  {888,8},
  {890,1550},
  {892,1324},
  {894,1195},
  {896,1257},
  {898,511},
  {900,1690},
  {902,666},
  {904,410},
  {906,593},
  {908,553},
  {910,1565},
  {912,960},
  {914,742},
  {916,1403},
  {918,352},
  {920,1307},
  {922,141},
  {924,910},
  {926,1200},
  {928,799},
  {930,1127},
  {932,171},
  {934,1787},
  {936,414},
  {938,1625},
  {940,641},
  {942,1517},
  {944,1348},
  {946,1842},
  {948,315},
  {950,1974},
  {952,1445},
  {954,1373},
  {956,220},
  {958,1911},
  {960,1239},
  {962,1054},
  {964,1305},
  {966,929},
  {968,253},
  {970,189},
  {972,1166},
  {974,356},
  {976,1304},
  {978,1860},
  {980,1898},
  {982,1592},
  {984,1720},
  {986,116},
  {988,1580},
  {990,867},
  {992,1352},
  {994,939},
  {996,698},
  {998,901},
  {1000,811},
  {1002,616},
  {1004,891},
  {1006,671},
  {1008,1728},
  {1010,671},
  {1012,1661},
  {1014,1045},
  {1016,1120},
  {1018,240},
  {1020,1158},
  {1022,1453},
  {1024,1627},
  {1026,1350},
  {1028,1711},
  {1030,1563},
  {1032,1594},
  {1034,1533},
  {1036,1727},
  {1038,1827},
  {1040,795},
  {1042,1531},
  {1044,1442},
  {1046,1516},
  {1048,1006},
  {1050,515},
  {1052,924},
  {1054,601},
  {1056,1097},
  {1058,661},
  {1060,1103},
  {1062,324},
  {1064,108},
  {1066,936},
  {1068,281},
  {1070,1015},
  {1072,1710},
  {1074,1216},
  {1076,1905},
  {1078,1973},
  {1080,1781},
  {1082,720},
  {1084,791},
  {1086,1169},
  {1088,1865},
  {1090,1827},
  {1092,1536},
  {1094,728},
  {1096,1125},
  {1098,384},
  {1100,167},
  {1102,1949},
  {1104,476},
  {1106,46},
  {1108,1576},
  {1110,666},
  {1112,1467},
  {1114,520},
  {1116,1384},
  {1118,1991},
  {1120,1210},
  {1122,1258},
  {1124,211},
  {1126,744},
  {1128,1518},
  {1130,1718},
  {1132,1934},
  {1134,825},
  {1136,767},
  {1138,689},
  {1140,1818},
  {1142,1014},
  {1144,1825},
  {1146,918},
  {1148,28},
  {1150,1029},
  {1152,34},
  {1154,727},
  {1156,1240},
  {1158,1754},
  {1160,540},
  {1162,396},
  {1164,935},
  {1166,1083},
  {1168,48},
  {1170,865},
  {1172,1011},
  {1174,1252},
  {1176,1064},
  {1178,1876},
  {1180,1237},
  {1182,675},
  {1184,245},
  {1186,710},
  {1188,415},
  {1190,192},
  {1192,710},
  {1194,747},
  {1196,1037},
  {1198,1299},
  {1200,447},
  {1202,1715},
  {1204,1693},
  {1206,1579},
  {1208,1129},
  {1210,1164},
  {1212,1979},
  {1214,1501},
  {1216,1525},
  {1218,289},
  {1220,958},
  {1222,33},
  {1224,1800},
  {1226,1089},
  {1228,1670},
  {1230,1217},
  {1232,846},
  {1234,1038},
  {1236,1543},
  {1238,338},
  {1240,1936},
  {1242,1321},
  {1244,1719},
  {1246,496},
  {1248,1247},
  {1250,1788},
  {1252,359},
  {1254,1987},
  {1256,1035},
  {1258,1235},
  {1260,1912},
  {1262,1684},
  {1264,1989},
  {1266,1784},
  {1268,1734},
  {1270,667},
  {1272,519},
  {1274,615},
  {1276,1045},
  {1278,1976},
  {1280,661},
  {1282,1825},
  {1284,819},
  {1286,1631},
  {1288,903},
  {1290,698},
  {1292,798},
  {1294,639},
  {1296,4},
  {1298,1503},
  {1300,679},
  {1302,765},
  {1304,1391},
  {1306,107},
  {1308,924},
  {1310,365},
  {1312,1121},
  {1314,454},
  {1316,1106},
  {1318,1450},
  {1320,1703},
  {1322,832},
  {1324,1032},
  {1326,141},
  {1328,1654},
  {1330,1977},
  {1332,217},
  {1334,1900},
  {1336,1289},
  {1338,1465},
  {1340,747},
  {1342,1622},
  {1344,1879},
  {1346,1317},
  {1348,1516},
  {1350,48},
  {1352,762},
  {1354,1029},
  {1356,1039},
  {1358,708},
  {1360,1903},
  {1362,657},
  {1364,761},
  {1366,1752},
  {1368,1466},
  {1370,621},
  {1372,557},
  {1374,996},
  {1376,955},
  {1378,930},
  {1380,1494},
  {1382,1555},
  {1384,221},
  {1386,1312},
  {1388,293},
  {1390,1427},
  {1392,232},
  {1394,1444},
  {1396,791},
  {1398,198},
  {1400,1152},
  {1402,856},
  {1404,1570},
  {1406,303},
  {1408,1439},
  {1410,914},
  {1412,1799},
  {1414,766},
  {1416,1835},
  {1418,1921},
  {1420,43},
  {1422,752},
  {1424,86},
  {1426,1719},
  {1428,1150},
  {1430,410},
  {1432,623},
  {1434,669},
  {1436,1605},
  {1438,1943},
  {1440,1311},
  {1442,431},
  {1444,1992},
  {1446,1816},
  {1448,699},
  {1450,971},
  {1452,639},
  {1454,1370},
  {1456,1836},
  {1458,1891},
  {1460,857},
  {1462,833},
  {1464,1328},
  {1466,177},
  {1468,410},
  {1470,1683},
  {1472,1176},
  {1474,1489},
  {1476,91},
  {1478,434},
  {1480,711},
  {1482,904},
  {1484,1026},
  {1486,891},
  {1488,790},
  {1490,522},
  {1492,1364},
  {1494,890},
  {1496,884},
  {1498,813},
  {1500,1441},
  {1502,1127},
  {1504,179},
  {1506,1784},
  {1508,537},
  {1510,1870},
  {1512,1561},
  {1514,581},
  {1516,165},
  {1518,1802},
  {1520,1732},
  {1522,1332},
  {1524,1854},
  {1526,1759},
  {1528,1847},
  {1530,377},
  {1532,462},
  {1534,1010},
  {1536,1819},
  {1538,150},
  {1540,1377},
  {1542,941},
  {1544,1836},
  {1546,720},
  {1548,299},
  {1550,112},
  {1552,759},
  {1554,1956},
  {1556,390},
  {1558,152},
  {1560,48},
  {1562,1014},
  {1564,1044},
  {1566,918},
  {1568,150},
  {1570,101},
  {1572,1295},
  {1574,1821},
  {1576,1731},
  {1578,501},
  {1580,245},
  {1582,961},
  {1584,57},
  {1586,1510},
  {1588,1928},
  {1590,805},
  {1592,173},
  {1594,137},
  {1596,1669},
  {1598,1096}
};

main()
{
	binary_search(0);
	;
}

binary_search(x)
{
  int fvalue, mid, up, low ;
  
  low = 0;
  up = TABSIZE-1;
  fvalue = -1 /* all data are positive */ ;
  while (low <= up) {
    mid = (low + up) >> 1;
    if ( data[mid].key == x ) {  /*  found  */
      up = low - 1;
      fvalue = data[mid].value;
#ifdef DEBUG
      printf("FOUND!!\n");
#endif
    }
    else  /* not found */
      if ( data[mid].key > x ) 	{
        up = mid - 1;
#ifdef DEBUG
        printf("MID-1\n");
#endif
      }
      else   {
        low = mid + 1;
#ifdef DEBUG
        printf("MID+1\n");
#endif
      }
#ifdef DEBUG
    cnt1++;
#endif
  }
#ifdef DEBUG
	printf("Loop Count : %d\n", cnt1);
#endif
  return fvalue;
}

